/*	physio.c	1.6	83/07/18	*/

#include <stdio.h>
#include "cpmio.h"

/************************************************************************
 * NAME:	cpm_putpsect()
 *
 * DESCR:	Write physical sector to floppy disk file.
 *
 * ARGS:	
 *
 * RETURNS:	TRUE if OK, FALSE otherwise.
 *
 * NOTES:	- sector numbers coming in to this routine are from
 *		  1 to the number of sectors.  This is translated to
 *		  start at zero.
 *		- track numbers start from zero.
 ************************************************************************/
int
cpm_putpsect(struct cpmfs *cpmfs, int tr, int sect, char buf[])
{
	if (sect > cpmfs->sectrk || sect < 1) {
		return (FALSE);
	}

	return((*cpmfs->pwritesec)(cpmfs->device,0,tr,sect-1+cpmfs->startsec,buf));
}

/************************************************************************
 * NAME:	cpm_getpsect()
 *
 * DESCR:	Read physical sector from floppy disk file.
 *
 * ARGS:	
 *
 * RETURNS:	TRUE if OK, FALSE otherwise.
 *
 * NOTES:	- sector numbers coming in to this routine are from
 *		  1 to the number of sectors.  This is translated to
 *		  start at zero.
 *		- track numbers start from zero.
 ************************************************************************/
int
cpm_getpsect(struct cpmfs *cpmfs, int tr, int sect, char buf[])
{
	if (sect > cpmfs->sectrk || sect < 1) {
		return (FALSE);
	}

	return((cpmfs->preadsec)(cpmfs->device,0,tr,sect-1+cpmfs->startsec,buf));
}

